/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.sit;

import de.teamlapen.vampirism.sit.SitEntity;
import de.teamlapen.vampirism.sit.SitUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class SitHandler {
    public static void startSitting(@NotNull Player player, @NotNull Level level, @NotNull BlockPos pos, double offset) {
        SitEntity sit;
        if (!level.isClientSide && !SitUtil.isPlayerSitting(player) && !player.isShiftKeyDown() && SitHandler.isPlayerInRange(player, pos) && !SitUtil.isOccupied(level, pos) && player.getMainHandItem().isEmpty() && SitUtil.addSitEntity(level, pos, sit = SitEntity.newEntity(level, pos, offset, player.position()))) {
            level.addFreshEntity((Entity)sit);
            player.startRiding((Entity)sit);
        }
    }

    @SubscribeEvent
    public static void onBreak(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull BlockEvent.BreakEvent event) {
        SitEntity entity;
        if (!event.getLevel().isClientSide() && (entity = SitUtil.getSitEntity((Level)event.getLevel(), event.getPos())) != null) {
            entity.discard();
        }
    }

    private static boolean isPlayerInRange(@NotNull Player player, BlockPos pos) {
        Vec3 playerPos = player.position();
        Vec3 blockPos = new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        double blockReachDistance = player.getAttribute(Attributes.BLOCK_INTERACTION_RANGE).getValue();
        blockPos = blockPos.add(0.5, 0.5, 0.5);
        AABB range = new AABB(blockPos.x() + blockReachDistance, blockPos.y() + blockReachDistance, blockPos.z() + blockReachDistance, blockPos.x() - blockReachDistance, blockPos.y() - blockReachDistance, blockPos.z() - blockReachDistance);
        return range.minX <= (playerPos = playerPos.add(0.5, 0.5, 0.5)).x() && range.minY <= playerPos.y() && range.minZ <= playerPos.z() && range.maxX >= playerPos.x() && range.maxY >= playerPos.y() && range.maxZ >= playerPos.z();
    }
}

