/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.gen.feature.treedecorators;

import com.mojang.serialization.MapCodec;
import de.teamlapen.vampirism.blocks.DiagonalCursedBarkBlock;
import de.teamlapen.vampirism.blocks.DirectCursedBarkBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModFeatures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import org.jetbrains.annotations.NotNull;

public class TrunkCursedVineDecorator
extends TreeDecorator {
    public static final TrunkCursedVineDecorator INSTANCE = new TrunkCursedVineDecorator();
    public static final MapCodec<TrunkCursedVineDecorator> CODEC = MapCodec.unit(() -> INSTANCE);

    @NotNull
    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)ModFeatures.TRUNK_CURSED_VINE.get();
    }

    public void place(@NotNull TreeDecorator.Context context) {
        context.logs().forEach(trunkPos -> {
            if (context.level().isStateAtPosition(trunkPos, state -> state.hasProperty((Property)BlockStateProperties.AXIS))) {
                this.placeCursedVine(context, (BlockPos)trunkPos);
            }
        });
    }

    protected void placeCursedVine(@NotNull TreeDecorator.Context context, @NotNull BlockPos pos) {
        if (context.level().isStateAtPosition(pos, state -> state.getValue((Property)BlockStateProperties.AXIS) == Direction.Axis.X)) {
            this.placeCursedVineX(context, pos);
        } else if (context.level().isStateAtPosition(pos, state -> state.getValue((Property)BlockStateProperties.AXIS) == Direction.Axis.Y)) {
            this.placeCursedVineY(context, pos);
        } else {
            this.placeCursedVineZ(context, pos);
        }
    }

    protected void placeCursedVineX(@NotNull TreeDecorator.Context context, @NotNull BlockPos pos) {
        this.place(context, pos.north(), (BlockState)((DirectCursedBarkBlock)ModBlocks.DIRECT_CURSED_BARK.get()).defaultBlockState().setValue(DirectCursedBarkBlock.SOUTH_TYPE, (Comparable)((Object)DirectCursedBarkBlock.Type.HORIZONTAL)));
        this.place(context, pos.south(), (BlockState)((DirectCursedBarkBlock)ModBlocks.DIRECT_CURSED_BARK.get()).defaultBlockState().setValue(DirectCursedBarkBlock.NORTH_TYPE, (Comparable)((Object)DirectCursedBarkBlock.Type.HORIZONTAL)));
        this.place(context, pos.above(), (BlockState)((DirectCursedBarkBlock)ModBlocks.DIRECT_CURSED_BARK.get()).defaultBlockState().setValue(DirectCursedBarkBlock.DOWN_TYPE, (Comparable)((Object)DirectCursedBarkBlock.Type.HORIZONTAL)));
        this.place(context, pos.below(), (BlockState)((DirectCursedBarkBlock)ModBlocks.DIRECT_CURSED_BARK.get()).defaultBlockState().setValue(DirectCursedBarkBlock.UP_TYPE, (Comparable)((Object)DirectCursedBarkBlock.Type.HORIZONTAL)));
        this.place(context, pos.above().north(), (BlockState)((DiagonalCursedBarkBlock)ModBlocks.DIAGONAL_CURSED_BARK.get()).defaultBlockState().setValue((Property)DiagonalCursedBarkBlock.DOWN_SOUTH, (Comparable)Boolean.valueOf(true)));
        this.place(context, pos.north().below(), (BlockState)((DiagonalCursedBarkBlock)ModBlocks.DIAGONAL_CURSED_BARK.get()).defaultBlockState().setValue((Property)DiagonalCursedBarkBlock.UP_SOUTH, (Comparable)Boolean.valueOf(true)));
        this.place(context, pos.below().south(), (BlockState)((DiagonalCursedBarkBlock)ModBlocks.DIAGONAL_CURSED_BARK.get()).defaultBlockState().setValue((Property)DiagonalCursedBarkBlock.UP_NORTH, (Comparable)Boolean.valueOf(true)));
        this.place(context, pos.south().above(), (BlockState)((DiagonalCursedBarkBlock)ModBlocks.DIAGONAL_CURSED_BARK.get()).defaultBlockState().setValue((Property)DiagonalCursedBarkBlock.DOWN_NORTH, (Comparable)Boolean.valueOf(true)));
    }

    protected void placeCursedVineY(@NotNull TreeDecorator.Context context, @NotNull BlockPos pos) {
        this.place(context, pos.north(), (BlockState)((DirectCursedBarkBlock)ModBlocks.DIRECT_CURSED_BARK.get()).defaultBlockState().setValue(DirectCursedBarkBlock.SOUTH_TYPE, (Comparable)((Object)DirectCursedBarkBlock.Type.VERTICAL)));
        this.place(context, pos.south(), (BlockState)((DirectCursedBarkBlock)ModBlocks.DIRECT_CURSED_BARK.get()).defaultBlockState().setValue(DirectCursedBarkBlock.NORTH_TYPE, (Comparable)((Object)DirectCursedBarkBlock.Type.VERTICAL)));
        this.place(context, pos.east(), (BlockState)((DirectCursedBarkBlock)ModBlocks.DIRECT_CURSED_BARK.get()).defaultBlockState().setValue(DirectCursedBarkBlock.WEST_TYPE, (Comparable)((Object)DirectCursedBarkBlock.Type.VERTICAL)));
        this.place(context, pos.west(), (BlockState)((DirectCursedBarkBlock)ModBlocks.DIRECT_CURSED_BARK.get()).defaultBlockState().setValue(DirectCursedBarkBlock.EAST_TYPE, (Comparable)((Object)DirectCursedBarkBlock.Type.VERTICAL)));
        this.place(context, pos.east().north(), (BlockState)((DiagonalCursedBarkBlock)ModBlocks.DIAGONAL_CURSED_BARK.get()).defaultBlockState().setValue((Property)DiagonalCursedBarkBlock.WEST_SOUTH, (Comparable)Boolean.valueOf(true)));
        this.place(context, pos.north().west(), (BlockState)((DiagonalCursedBarkBlock)ModBlocks.DIAGONAL_CURSED_BARK.get()).defaultBlockState().setValue((Property)DiagonalCursedBarkBlock.SOUTH_EAST, (Comparable)Boolean.valueOf(true)));
        this.place(context, pos.west().south(), (BlockState)((DiagonalCursedBarkBlock)ModBlocks.DIAGONAL_CURSED_BARK.get()).defaultBlockState().setValue((Property)DiagonalCursedBarkBlock.EAST_NORTH, (Comparable)Boolean.valueOf(true)));
        this.place(context, pos.south().east(), (BlockState)((DiagonalCursedBarkBlock)ModBlocks.DIAGONAL_CURSED_BARK.get()).defaultBlockState().setValue((Property)DiagonalCursedBarkBlock.NORTH_WEST, (Comparable)Boolean.valueOf(true)));
    }

    protected void placeCursedVineZ(@NotNull TreeDecorator.Context context, @NotNull BlockPos pos) {
        this.place(context, pos.above(), (BlockState)((DirectCursedBarkBlock)ModBlocks.DIRECT_CURSED_BARK.get()).defaultBlockState().setValue(DirectCursedBarkBlock.DOWN_TYPE, (Comparable)((Object)DirectCursedBarkBlock.Type.VERTICAL)));
        this.place(context, pos.below(), (BlockState)((DirectCursedBarkBlock)ModBlocks.DIRECT_CURSED_BARK.get()).defaultBlockState().setValue(DirectCursedBarkBlock.UP_TYPE, (Comparable)((Object)DirectCursedBarkBlock.Type.VERTICAL)));
        this.place(context, pos.east(), (BlockState)((DirectCursedBarkBlock)ModBlocks.DIRECT_CURSED_BARK.get()).defaultBlockState().setValue(DirectCursedBarkBlock.WEST_TYPE, (Comparable)((Object)DirectCursedBarkBlock.Type.HORIZONTAL)));
        this.place(context, pos.west(), (BlockState)((DirectCursedBarkBlock)ModBlocks.DIRECT_CURSED_BARK.get()).defaultBlockState().setValue(DirectCursedBarkBlock.EAST_TYPE, (Comparable)((Object)DirectCursedBarkBlock.Type.HORIZONTAL)));
        this.place(context, pos.east().above(), (BlockState)((DiagonalCursedBarkBlock)ModBlocks.DIAGONAL_CURSED_BARK.get()).defaultBlockState().setValue((Property)DiagonalCursedBarkBlock.DOWN_WEST, (Comparable)Boolean.valueOf(true)));
        this.place(context, pos.above().west(), (BlockState)((DiagonalCursedBarkBlock)ModBlocks.DIAGONAL_CURSED_BARK.get()).defaultBlockState().setValue((Property)DiagonalCursedBarkBlock.DOWN_EAST, (Comparable)Boolean.valueOf(true)));
        this.place(context, pos.west().below(), (BlockState)((DiagonalCursedBarkBlock)ModBlocks.DIAGONAL_CURSED_BARK.get()).defaultBlockState().setValue((Property)DiagonalCursedBarkBlock.UP_EAST, (Comparable)Boolean.valueOf(true)));
        this.place(context, pos.below().east(), (BlockState)((DiagonalCursedBarkBlock)ModBlocks.DIAGONAL_CURSED_BARK.get()).defaultBlockState().setValue((Property)DiagonalCursedBarkBlock.UP_WEST, (Comparable)Boolean.valueOf(true)));
    }

    protected void place(@NotNull TreeDecorator.Context context, @NotNull BlockPos pos, @NotNull BlockState state) {
        if (context.level().isStateAtPosition(pos, BlockBehaviour.BlockStateBase::isAir)) {
            context.setBlock(pos, state);
        }
    }
}

