/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.item;

import guideme.internal.GuideME;
import guideme.internal.GuideMEProxy;
import guideme.internal.GuidebookText;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class GuideItem
extends Item {
    public static final ResourceLocation ID = GuideME.makeId("guide");
    public static final ResourceLocation BASE_MODEL_ID = ID.withPrefix("item/").withSuffix("_base");
    public static final Item.Properties PROPERTIES = new Item.Properties();

    public GuideItem(Item.Properties properties) {
        super(properties);
    }

    public Component getName(ItemStack stack) {
        Component name;
        ResourceLocation guideId = GuideItem.getGuideId(stack);
        if (guideId != null && (name = GuideMEProxy.instance().getGuideDisplayName(guideId)) != null) {
            return name;
        }
        return super.getName(stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag tooltipFlag) {
        ResourceLocation guideId = GuideItem.getGuideId(stack);
        if (guideId != null) {
            GuideMEProxy.instance().addGuideTooltip(guideId, context, lines, tooltipFlag);
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        ResourceLocation guideId = GuideItem.getGuideId(player.getItemInHand(hand));
        if (level.isClientSide) {
            if (guideId == null) {
                player.sendSystemMessage((Component)GuidebookText.ItemNoGuideId.text());
            } else if (GuideMEProxy.instance().openGuide(player, guideId)) {
                return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
            }
        }
        return InteractionResultHolder.success((Object)stack);
    }

    @Nullable
    public static ResourceLocation getGuideId(ItemStack stack) {
        return (ResourceLocation)stack.get(GuideME.GUIDE_ID_COMPONENT);
    }
}

