/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.mixin.features.render.world.clouds;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.caffeinemc.mods.sodium.client.render.immediate.CloudRenderer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public class LevelRendererMixin {
    @Shadow
    @Nullable
    private ClientLevel level;
    @Shadow
    private int ticks;
    @Shadow
    @Final
    private Minecraft minecraft;
    @Unique
    private CloudRenderer cloudRenderer;

    @Inject(method={"renderClouds"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/DimensionSpecialEffects;getCloudHeight()F")}, cancellable=true)
    public void renderClouds(PoseStack poseStack, Matrix4f matrix4f, Matrix4f projectionMatrix, float tickDelta, double x, double y, double z, CallbackInfo ci) {
        ci.cancel();
        if (this.cloudRenderer == null) {
            this.cloudRenderer = new CloudRenderer((ResourceProvider)this.minecraft.getResourceManager());
        }
        poseStack.pushPose();
        poseStack.mulPose(matrix4f);
        ClientLevel level = Objects.requireNonNull(this.level);
        Camera camera = this.minecraft.gameRenderer.getMainCamera();
        this.cloudRenderer.render(camera, level, projectionMatrix, poseStack, this.ticks, tickDelta);
        poseStack.popPose();
    }

    @Inject(method={"onResourceManagerReload(Lnet/minecraft/server/packs/resources/ResourceManager;)V"}, at={@At(value="RETURN")})
    private void onReload(ResourceManager manager, CallbackInfo ci) {
        if (this.cloudRenderer != null) {
            this.cloudRenderer.reload((ResourceProvider)manager);
        }
    }

    @Inject(method={"allChanged()V"}, at={@At(value="RETURN")})
    private void onReload(CallbackInfo ci) {
        if (this.cloudRenderer != null) {
            this.cloudRenderer.destroy();
            this.cloudRenderer = null;
        }
    }

    @Inject(method={"close"}, at={@At(value="RETURN")})
    private void onClose(CallbackInfo ci) {
        if (this.cloudRenderer != null) {
            this.cloudRenderer.destroy();
            this.cloudRenderer = null;
        }
    }
}

